<?php
$host = $_SERVER['HTTP_HOST'];

if (strpos($host, 'partageparauapebas') === false) {
  header('Location: /');
  exit();
}

include 'assets/inc/header.php';
?>

<style>
  @import url('https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap');

  footer,
  header,
  .menu-secundario {
    display: none;
  }

  #hero h1 {
    display: inline-block;
    text-align: left;
  }


    {
    --red: #ad132a;
  }

  .body * {
    font-family: "Poppins", sans-serif;
    font-weight: 300;
    font-style: normal;
    --title-size: 50px;
  }

  .body hr {
    border-top: 2px solid #000000;
    opacity: 1;
    width: 80%;
    max-width: 830px;
    margin: 100px auto 95px auto;
  }

  #page {
    margin: 8vw auto;
  }

  .modal {
    display: none;
    position: fixed;
    z-index: 99;
    left: 28vw;
    top: 14vw;
    overflow: visible;
    background: none;
    transition: opacity 0.5s ease, transform 0.5s ease;
    transform: scale(0.9);
  }

  .modal.fade {
    opacity: 0;
    transition: opacity 0.15s linear;
    transition: opacity 0.5s ease, transform 0.5s ease;
  }

  .modal.show {
    display: block;
    opacity: 1;
    transform: scale(1);
  }

  .modal-body {
    background-color: #fff;
    border-radius: 30px 130px;
    padding: 40px 0;
    -webkit-box-shadow: 2px 2px 10px 0px rgba(194, 194, 194, 1);
    -moz-box-shadow: 2px 2px 10px 0px rgba(194, 194, 194, 1);
    box-shadow: 2px 2px 10px 0px rgba(194, 194, 194, 1);
  }

  .modal-txt {
    padding: 0 30px 0 12vw;
  }

  .modal-body p {
    white-space: pre-line;
    font-size: 14px;
    font-weight: 400;
  }

  .modal-header {
    display: flex;
    align-content: flex-end;
    background-color: transparent !important;
    background: none;
    border-bottom: none;
    justify-content: flex-end;
    padding: 0 40px;
    position: relative
  }

  .modal-header a {
    color: #000;
    text-decoration: none;
    margin: 0 !important;
    position: absolute;
    top: 1vw;
    right: 8vw
  }

  .modal-content {
    border: none !important;
    background-color: transparent !important;
    border-radius: 30px 130px
  }

  .painelistas-modal {
    position: absolute;
    left: -4vw;
    top: -180px;
    width: 15vw;
  }

  #main {
    /* background: url('https://upload.madnezz.com.br/be931142cdbf8fc2923ef3ecfc51fea6') no-repeat right 0; */
    background-size: 32vw;
    top: -55px
  }

  #hero {
    min-height: 60vh;
  }

  #hero h1 {
    font-family: "Poppins", sans-serif;
    font-size: 65px;
    font-weight: 300;
    color: #ad132a;
    line-height: 1;
  }

  #hero h1 sub {
    font-size: .6em;
    vertical-align: middle;
    line-height: 1;
    top: .1em;
  }

  #hero h1>span {
    color: #000;
    font-size: 1em;
  }

  #hero h1 .small-1 {
    color: #ad132a;
    font-size: .65em;
    font-weight: 600;
  }

  #hero h1 .small-2 {
    color: #000;
  }

  #cta .container {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 40px;
    padding: 10vw;
  }

  #cta h2 {
    color: #ad132a;
    font-weight: 700;
    font-size: var(--title-size);
    text-align: center;
    margin: auto;
  }

  #cta a {
    background: #ad132a;
    max-width: 260px;
    color: #fff;
    text-decoration: none;
    padding: 12px 24px;
    border-radius: 30px;
  }

  #painelistas h2 {
    font-size: var(--title-size);
    color: #000;
    text-align: center;
    font-weight: 300;
  }

  #painelistas h2 b {
    color: #ad132a;
    font-weight: 600;
  }

  .btn-close {
    font-size: 32px;
  }

  #painelistas .container-painelistas {
    display: flex;
    flex-wrap: wrap;
    gap: 50px 6%;
  }

  #painelistas .container-painelistas .item {
    width: 19%;
    cursor: pointer;
  }

  #painelistas .container-painelistas .item img {
    height: 350px;
    object-fit: contain
  }

  #painelistas .item h3 {
    color: #ad132a;
    font-size: 18px;
    font-weight: 600;
    margin: 20px 0 12px 0;
  }

  #painelistas .item h4 {
    font-size: 14px;
    font-weight: 700;
    margin: 0;
  }

  #painelistas small {
    font-size: 12px;
    line-height: 1.5;
    display: inline-block;
    margin-top: 7px;
  }

  #programacao::before {
    content: '';
    /* background: url('https://www.partagebetim.com.br/wp-content/uploads/sites/3/2024/05/petala_3-1.png') no-repeat right;  */
    width: 23%;
    height: 40vw;
    position: absolute;
    top: 0px;
    right: 0;
    background-size: contain;
  }

  #programacao h2 {
    font-size: var(--title-size);
    font-weight: 600;
    text-align: center;
    color: #ad132a;
  }

  #programacao table {
    font-size: 22px;
  }

  #programacao tr>td {
    color: #ad132a;
    padding-bottom: 30px;
  }

  #programacao tr>td:first-child {
    font-weight: 600;
    min-width: 130px;
    color: #000;
  }

  #programacao td span {
    font-size: .7em;
  }

  #bg-flower {
    position: relative
  }

  #bg-flower img {
    position: absolute;
    width: 21vw;
    top: -14vw
  }


  #fotos .container {
    padding: 20px 0 40px;
    text-align: center;
  }

  #fotos h2 {
    color: #000;
    font-size: 40px;
    font-weight: 100;
  }

  #fotos h2 strong {
    color: #8B221D;
    display: block;
    font-weight: 900;
    margin: -10px 0 60px 0;
  }

  #fotos .btn-fotos {
    padding: 10px 20px;
    width: 100%;
    max-width: 250px;
    font-size: 22px;
    font-weight: 900;
    background: #8B221D;
    border: solid 1px #8b221d;
    text-transform: capitalize;
    text-decoration: none;
    margin: 0 auto;
    color: #fff;
    transition: ease.5s all;
    display: block;
  }

  #fotos .btn-fotos:hover {
    background: #fff;
    color: #8B221D;
  }

  #participacao {
    text-align: right;
    /* background: url('https://www.partagebetim.com.br/wp-content/uploads/sites/3/2024/05/petala_betim_2.png') no-repeat left 0; */
    padding: 40px 0;
    background-size: 28vw;
    position: relative;
  }

  #participacao .container {
    max-width: 999px;
  }

  #participacao h2 {
    font-size: calc(var(--title-size) + 18px);
    color: #000;
    font-weight: 300;
    margin-bottom: 45px;
    line-height: 1;
  }

  #participacao h2 b {
    color: #ad132a;
    font-weight: 600;
    display: block;
  }

  #participacao p {
    font-size: 28px;
  }

  #participacao p b {
    color: #ad132a;
  }

  #participacao .wpcf7,
  #participacao form {
    display: flex;
    flex-direction: column;
    gap: 45px;
    align-items: flex-end;
    margin-left: auto;
    margin-right: 0;
    max-width: 590px;
  }

  #participacao .wpcf7 label {
    display: block;
  }

  #participacao .wpcf7 input {
    font-size: 18px;
    /* padding: 10px 15px; */
    padding: 16px;
    border: 1px solid #000;
    display: block;
    width: 100%;
    max-width: 100%;
  }

  #participacao .wpcf7 input[name="your-phone"],
  #participacao .wpcf7 input[name="your-company"] {
    max-width: 60%;
    margin-left: auto;
  }

  #participacao .wpcf7 .wpcf7-acceptance label {
    display: flex;
    gap: 17px;
    text-align: left;
  }

  #participacao .wpcf7 .wpcf7-acceptance input {
    padding: 13px;
    border-radius: 0;
    width: auto;
    transition: .2s;
  }

  #participacao .wpcf7 .form-check-input:checked[type="checkbox"] {
    background-color: #ad132a;
  }

  #participacao .wpcf7 input[type="submit"] {
    background: #ad132a;
    color: #fff;
    border: none;
    border-radius: 999px;
    padding: 10px 30px;
    font-size: 18px;
    margin: 0px 0 14px auto;
    width: auto;
  }

  #participacao .wpcf7 .mini-input {
    margin-left: 12vw;
    max-width: 60%;
  }

  #realizacao {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 40px
  }

  #realizacao .logos {
    width: 100%;
    display: flex;
    justify-content: space-evenly;
  }

  #realizacao .logos div {
    display: flex;
    flex-direction: column;
    gap: 20px;
    align-items: center;
    justify-content: center;
  }

  #realizacao .d-flex {
    gap: 30px 40px;
  }

  #realizacao .parceiros {
    display: flex;
    justify-content: space-evenly;
    gap: 30px;
    flex-wrap: wrap;
  }

  #realizacao .parceiros img {
    height: 30px;
    width: auto;
    /* max-width: 117px; */
  }

  .mandala {
    position: absolute;
    top: -8vw;
    right: -335px;
    ;

  }

  .mandala-2 {
    top: -4vw;
    left: -19.8vw;
    position: absolute;
    width: 50%;
  }


  .mandala-metade {
    position: absolute;
    right: -340px;
    top: -6vw;
    /* width: 18vw */
  }

  .petala {
    position: absolute;
    left: -28vw;
    width: 30vw;
    top: 31vw;
  }

  .petala.cta {
    position: absolute;
    left: -28vw;
    width: 35vw;
    top: 29vw;
  }

  #programacao table {
    font-size: 22px;
    margin: 0px 8vw;
  }

  /* #fotos h2 { font-size:5rem; margin:0 12vw }
      #fotos h2 .small-1 { font-size:4rem; } */

  #pesquisa {
    display: flex;
    gap: 40px;
    text-align: center;
    height: 24vw;
    justify-content: center;
    flex-direction: column;
  }

  #pesquisa h2 {
    font-size: 44px;
    color: #ad132a;
    font-weight: 800;
  }

  #pesquisa a {
    color: #fff;
    background: #ad132a;
    border-radius: 24px;
    padding: 8px 80px;
    text-transform: capitalize;
    text-decoration: none
  }

  #pesquisa a:hover {
    color: #ad132a;
    background: #fff;
    border: 1px solid #ad132a
  }

  .btn-fotos {
    color: #fff;
    background: #ad132a;
    border-radius: 100px;
    padding: 22px 100px;
    text-transform: capitalize;
    text-decoration: none;
    margin: 0 auto;
  }

  .btn-fotos:hover {
    color: #ad132a;
    background: #fff;
    border: 1px solid #ad132a
  }

  .footer {
    display: flex;
    align-items: center;
    gap: 10vw;
    display: flex;
    align-items: center;
    margin: 0 auto;
    justify-content: center;
  }

  .footer span {
    color: #ad132a;
  }

  .footer .social {
    gap: 20px;
  }

  .footer .social a {
    color: gray;
    text-decoration: none;
  }

  .footer .social a:hover i {
    color: #ad132a;
  }

  .footer div svg {
    height: 17px;
    width: auto
  }

  .footer div svg:hover {
    fill: #ad132a;
  }

  .footer ul {
    display: flex;
    flex-direction: row;
    gap: 14px
  }

  .btn-resposta {
    display: flex;
    flex-direction: row;
    align-items: center;
    gap: 16px
  }


  .modal-open {
    overflow: hidden;
  }

  #md-2 {
    display: none;
  }

  #modal-text {
    max-height: calc(100vh - 500px);
    overflow-y: auto;
  }

  #md-2.show {
    display: block;
    position: fixed;
    top: 10vw;
    left: 16vw;
    width: 100%;
    height: 100%;
    /* background: rgba(0, 0, 0, 0.5); */
    z-index: 1050;
  }

  #md-2 .modal-content {
    position: relative;
    margin: auto;
    padding: 20px;
    background: white;
    border-radius: 10px;
    max-width: 800px;
  }


  @media (max-width: 1400px) {

    /* html{    padding-left: 8vw; overflow-x: hide} */
    .mandala {
      position: absolute;
      top: -8vw;
      right: -74px;
    }

    .mandala-metade {
      position: absolute;
      right: -80px;
      top: 0;
      width: 19vw;
    }

    .petala {
      position: absolute;
      left: -19vw;
      width: 50vw;
      top: 50vw;
    }

    #participacao .wpcf7 .mini-input {
      margin-left: 17vw;
      max-width: 60%;
    }

  }

  @media (max-width: 767px) {
    html {
      margin-left: 0;
      overflow-y: hide
    }

    .body * {
      --title-size: 22px;
      padding: 0;

    }

    .body {
      width: 100%;
    }

    .body hr {
      margin: 40px auto 45px auto;
    }

    #page {
      margin: 6vw
    }

    .petala {
      display: none;
    }

    .mandala {
      width: 60vw;
      left: 15vw;
    }

    .mandala-metade {
      display: none
    }

    .modal {
      left: 5vw;
      height: 96vh;
      overflow-y: scroll;
      width: calc(100% - 40px);
    }

    #main {
      background-size: 47vw;
    }

    #hero {
      min-height: 0;
      padding-top: 180px;
    }

    #hero h1 {
      font-size: 35px;
    }

    #cta {
      background-size: 176px;
      min-height: 276px;
      background-image: none;
    }

    /* #fotos {
          background-image: none;
        }
        #fotos h2 { font-size:3rem; }
        #fotos h2 .small-1 { font-size:2rem; } */

    #painelistas .container-painelistas .item {
      width: 44%;
    }

    #painelistas .container-painelistas .item img {
      height: 200px;
      object-fit: contain
    }

    #painelistas .container-painelistas {
      gap: 37px 5%;
    }

    #programacao table {
      font-size: 16px;
    }

    #programacao tr>td:first-child {
      min-width: 88px;
    }

    #programacao::before {
      background: none;
      top: -141px;
    }

    /* #fotos h2::before {
          top: initial;
          left: initial;
          font-size: 22px;
          position: relative;
          display: block;
        } */

    #participacao {
      padding: 0;
      background: none;
    }

    .parceiros {
      display: flex;
      align-items: center;
      justify-content: center;
      flex-wrap: wrap;
      gap: 16px
    }

    #realizacao .parceiros span {
      text-align: center;
    }

    #participacao .wpcf7,
    #participacao form {
      max-width: calc(100vw - 40px);
    }

    #participacao .wpcf7 input {
      max-width: 90%;
    }

    .mini-input {
      margin-left: 0 !important;
      max-width: 90% !important;
    }

    .btn-resposta {
      flex-direction: column
    }

    .painelistas-modal {
      height: 200px !important;
      width: auto;
      left: -19px;
      top: -44vw;
    }

    .modal-body {
      padding: 130px 30px 40px 30px !important;
    }

    .modal-txt {
      padding-top: 40px
    }

    .mobile-hide: {
      display: none !important;
    }

    #bg-flower img {
      display: none
    }

    #realizacao .logos {
      flex-direction: column;
      gap: 25px
    }

    #realizacao .parceiros img {
      height: 30px;
      width: auto;
      /* max-width: 117px; */
    }

    #md-2.show {
      display: block;
      position: fixed;
      top: 6vw;
      left: 0vw;
    }

    #pesquisa {
      height: 80vw;
    }

    #pesquisa h2 {
      font-size: 26px
    }

    .footer {
      flex-wrap: wrap;
      gap: 40px
    }
  }

  .big-title {
    font-size: 110px;
  }

  @media screen and (max-width:500px) {
    .big-title {
      font-size: 40px;
    }

    #participacao h2 {
      font-size: 40px;
    }
  }
</style>
<style>
  #banner img {
    width: 100%;
  }

  #form {
    background-image: url(https://qa-uploads.madnezz.com.br/d29bce188a742e267ef0081f3c934c42);
    background-color: #be180c;
    height: 1024px;
    width: calc(100% - 30px);
    padding: 0 15px;
    background-repeat: no-repeat;
    background-size: 100%;
    display: flex;
    flex-wrap: wrap;
    justify-content: center;
    align-items: center;
    flex-direction: column;
  }

  #form h2 {
    color: #fff;
    font-size: 60px;
    font-weight: 400;
    margin: 30px 0 15px 0;
    text-align: center;
  }

  #form h2 span {
    font-weight: 700;
  }

  #form h2::after {
    content: "";
    display: inline-block;
    width: 84px;
    height: 84px;
    background-image: url('https://qa-uploads.madnezz.com.br/f83d48a0846173d5f5814a21f5277477');
    position: absolute;
    margin: -17px 0 0 25px;
  }

  #form h3 {
    color: #fff;
    font-size: 29px;
    font-weight: 300;
    margin: 0 0 50px 0;
  }

  #form h3 span {
    font-weight: 700;
  }

  #form h3::before {
    content: "";
    display: inline-block;
    width: 372px;
    height: 2px;
    background: #fff;
    position: absolute;
    margin: 22px 0px 0 -401px;
  }

  #form h3::after {
    content: "";
    display: inline-block;
    width: 372px;
    height: 2px;
    background: #fff;
    position: absolute;
    margin: 22px 0 0 30px;
  }




  #form form {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
  }

  #form form input {
    max-width: 409px;
    height: 55px;
    margin-top: 15px;
    width: 100%;
    padding: 15px 38px;
    font-size: 20px;
    font-style: italic;
  }

  #form form input.grande {
    max-width: 628px;
  }

  #form form .input-resposta input {
    width: 21px !important;
    height: 21px !important;
    margin: 0 10px 0 0;
  }

  #form form .lgpd {
    max-width: 524px;
    color: #fff;
    font-size: 15px;
  }

  #form form .input-resposta {
    margin-top: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
  }


  #btn-validate {
    background: #fff;
    color: #ad132a;
    border: none;
    border-radius: 999px;
    width: 100%;
    max-width: 367px;
    height: 55px;
    font-size: 28px;
    padding: 0;
    font-weight: 700;
    margin-top: 25px;
    border: solid 1px #fff;
    transition: ease .5s all;
    cursor: pointer;
  }

  #btn-validate:hover {
    background: #ad132a;
    color: #fff;
  }


  #rodape {
    display: flex;
    align-items: center;
    justify-content: center;
    flex-direction: column;
    text-align: center;
    margin: 100px 0 80px;
  }

  #rodape p {
    margin-bottom: 70px;
  }

  #rodape .linha2 {
    display: flex;
    align-items: center;
    margin-bottom: 160px;
    flex-wrap: wrap;
    justify-content: center;
  }

  #rodape .linha2 img {
    padding: 30px;
    max-width: calc(100% - 60px);
  }

  #rodape .linha3 {
    display: flex;
    flex-wrap: wrap;
    align-items: center;
    justify-content: space-evenly;
    align-content: center;
    width: 100%;
  }

  #rodape .linha3 .logo {
    width: 193px;
    padding: 30px;
  }

  #rodape .linha3 span {
    color: #a21d16;
    font-size: 14px;
    padding: 30px;
  }

  #rodape .linha3 .redesSociais img {
    margin: 0 5px;
  }







  @media screen and (max-width:1299px) {
    #form h3::after {
      width: 70px;
    }

    #form h3::before {
      width: 70px;
      margin: 22px 0px 0 -98px;
    }
  }

  @media screen and (max-width:991px) {
    #form h2 {
      font-size: 40px;
    }

    #form h3 {
      font-size: 23px;
    }

    #form h2::after {
      width: 64px;
      height: 64px;
      background-size: contain;
    }

    #rodape {
      margin: 50px 0 40px;
    }

    #rodape p {
      margin-bottom: 20px;
    }

    #rodape .linha2 {
      margin-bottom: 0px;
    }
  }

  @media screen and (max-width:767px) {
    #banner img {
      margin-left: 0px;
    }

    #form h2::after {
      display: none;
    }
  }

  @media screen and (max-width:575px) {
    #banner img {
      margin-left: 0px;
    }

    #form h3::after,
    #form h3::before {
      display: none;
    }
  }

  @media screen and (max-width:500px) {
    .g-recaptcha {
      max-width: fit-content;
    }
  }
</style>
<div class="body">

  <div id="banner">
    <img src="https://qa-uploads.madnezz.com.br/f02173372faf9b3d12cb41524623f4b2" alt="">
  </div>

  <div id="form">
    <h2><span>Confirme</span> sua presença</h2>
    <h3><span>Preenchendo</span> o formulário abaixo</h3>
    <form id="formulario">
      <input class="grande" type="text" name="nome" placeholder="Nome Completo" required />
      <input class="grande" type="text" name="email" placeholder="E-mail" required />
      <input class=" mini-input" type="text" name="telefone" placeholder="Telefone (  ) _____ ____" required />
      <input class=" mini-input" type="text" name="cpf" placeholder="CPF" required />
      <input class=" mini-input" type="text" name="cargo" placeholder="Cargo" required />
      <input class=" mini-input" type="text" name="empresa" placeholder="Empresa" required />
      <div class="btn-resposta">
        <div class="input-resposta">
          <input type="checkbox" id="conscente" name="conscente" />
          <label for="conscente" class="lgpd">Eu estou ciente e concordo de que meus dados serão utilizados para receber
            as informações sobre o Fórum de Negócios de Parauapebas.</label>
        </div>
      </div>

      <div class="g-recaptcha" data-sitekey="<?php echo $recaptcha; ?>"></div>

      <button id="btn-validate" type="submit">Enviar</button>
      <div>
        <iframe frameborder="0" height="0" name="action"></iframe>
      </div>
    </form>

  </div>

  <div id="rodape">
    <div class="row linha1">
      <p>REALIZAÇÃO:</p>
    </div>

    <div class="row linha2">
      <img src="https://qa-uploads.madnezz.com.br/c72f83a8d53ed76990379c005d5a5ac6" alt="">
      <img src="https://qa-uploads.madnezz.com.br/173273b1be7a56e78ad28c727ebf497f" alt="">
    </div>

    <div class="row linha3">
      <img src="https://qa-uploads.madnezz.com.br/c72f83a8d53ed76990379c005d5a5ac6" class="logo">
      <span>© 2025 Grupo Partage - Todos os direitos reservados</span>
      <div class="redesSociais">
        <a href="#"><img src="https://qa-uploads.madnezz.com.br/bacd78c7a12bdadab17349fada7d015f"></a>
        <a href="#"><img src="https://qa-uploads.madnezz.com.br/5c56a156f6f855cb2b083a8625bef7ba"></a>
        <a href="#"><img src="https://qa-uploads.madnezz.com.br/25572a9c893d1a806339ca01dfe37a44"></a>
        <a href="#"><img src="https://qa-uploads.madnezz.com.br/bfc28f5ec95488e9b94b386d34a3b752"></a>
        <a href="#"><img src="https://qa-uploads.madnezz.com.br/c9122842fc153ed35a787b5331ff79f8"></a>
      </div>
    </div>
  </div>


</div>

<!-- <?php include 'assets/inc/footer.php'; ?><!-- -->
<script>
  $(function ($) {
    function validaEmail(email) {
      var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/; return re.test(email);
    }
    function valida_cpf(cpf) {
      var strCPF = cpf.replace(/[\.-]/g, '');
      var Soma = 0;
      var Resto;
      if (strCPF == "00000000000" || strCPF == "11111111111" || strCPF == "22222222222" || strCPF == "33333333333" || strCPF == "44444444444" || strCPF == "55555555555" || strCPF == "66666666666" || strCPF == "77777777777" || strCPF == "88888888888" || strCPF == "99999999999") return false;
      for (i = 1; i <= 9; i++) Soma += parseInt(strCPF.substring(i - 1, i)) * (11 - i);
      Resto = (Soma * 10) % 11;
      if ((Resto == 10) || (Resto == 11)) Resto = 0;
      if (Resto != parseInt(strCPF.substring(9, 10))) return false;
      Soma = 0;
      for (i = 1; i <= 10; i++) Soma += parseInt(strCPF.substring(i - 1, i)) * (12 - i);
      Resto = (Soma * 10) % 11;
      if ((Resto == 10) || (Resto == 11)) Resto = 0;
      if (Resto != parseInt(strCPF.substring(10, 11))) return false;
      return true;
    }

    $.mask.definitions["t"] = '[0-9]';
    $('[name="telefone"]').mask("(99) 99999 9999");
    $('[name="cpf"]').mask("999.999.999-99");

    $('#formulario').submit(function (event) {
      event.preventDefault();

      var nome = $('[name="nome"]').val().trim();
      var email = $('[name="email"]').val().trim();
      var telefone = $('[name="telefone"]').val();
      var cpf = $('[name="cpf"]').val();
      var cargo = $('[name="cargo"]').val().trim();
      var empresa = $('[name="empresa"]').val().trim();

      var recaptchaResponse = grecaptcha.getResponse();

      if (!recaptchaResponse) {
        alert('Preencha o Captcha');
        return false;
      } else if (!$("#conscente:checked").length) {
        alert("Favor aceitar nossos termos e políticas.");
        return false;
      } else if (!validaEmail(email)) {
        alert('Preencha um e-mail válido');
        return false;
      } else if (!nome) {
        alert('Preencha o nome corretamente');
        return false;
      } else if (!telefone) {
        alert('Preencha o campo telefone corretamente');
        return false;
      } else if (!valida_cpf(cpf)) {
        alert('Preencha um CPF válido');
        return false;
      } else if (!cargo) {
        alert('Preencha o campo cargo');
        return false;
      } else if (!empresa) {
        alert('Preencha o campo empresa');
        return false;
      } else {
        $('.contact-form form button').attr("disabled", true);
        $.ajax('https://api-public.madnezz.com.br/api/v1/public/sites/actions/franquia', {
          data: {
            "tk": "<?php echo $shopping_token; ?>",
            "shopping_id": "<?php echo $shopping_id; ?>",
            "nome": nome,
            "cpf": cpf,
            "email": email,
            "empresa": empresa,
            "telefone": telefone,
            "celular": "",
            "uf": "",
            "cidade": "",
            "investimento": "",
            "tipo": "",
            "lojista": "",
            "segmento": "Forum Parauapebas",
            "como": "",
            "observacao": cargo,
            "aux": "",
            "g-recaptcha-response": recaptchaResponse,
            "sendmail": 1
          },
          type: 'POST',
          dataType: 'json'
        }).then(function (data) {
          switch (data.message) {
            case "Mensagem enviada com sucesso!":
              alert("Mensagem enviada com sucesso");
              $('#formulario')[0].reset();
              break;
            default:
              alert("Erro ao enviar a mensagem, porfavor tente mais tarde");
              console.log("Erro: " + data);
              break;
          }
        });
        return false;
      }
    });
  });
</script>